/*
 *  GetClientDataRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */

package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.ClientData;
import com.avaya.ccs.javafxrefclient.JavaFXRefClient;
import com.avaya.ccs.javafxrefclient.Logger;
import javafx.concurrent.WorkerStateEvent;

public class GetClientDataRequest extends SessionRequest {

    private static final Logger LOG = Logger.getLogger(GetClientDataRequest.class);
    private final JavaFXRefClient gui;

    public GetClientDataRequest(JavaFXRefClient gui) {
        super(LOG);
        this.gui = gui;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        ClientData data;
        if (getClient() != null) {
            LOG.trace(methodName + "client non null");
            data = new ClientData(getClient());
        } else {
            LOG.trace(methodName + "client null, returning blank data");
            data = new ClientData(null);
        }
        return data;
    }

    @Override
    public void setSucceeded() {
        this.setOnSucceeded((WorkerStateEvent t) -> {
            String methodName = "succeededHandler() ";
            Object value = t.getSource().valueProperty().getValue();
            if (value != null) {
                ClientData newData = (ClientData) value;
                LOG.info(methodName + "ClientData:" + newData);
                gui.updateClientData(newData);
            } else {
                LOG.debug(methodName + " NULL");
            }
        });
    }
}
